/*
 * Decompiled with CFR 0.152.
 */
package shadows.gateways.gate;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.gateways.Gateways;
import shadows.placebo.codec.PlaceboCodecs;
import shadows.placebo.json.NBTAdapter;

public interface WaveEntity
extends PlaceboCodecs.CodecProvider<WaveEntity> {
    public static final BiMap<ResourceLocation, Codec<? extends WaveEntity>> CODECS = HashBiMap.create();
    public static final Codec<WaveEntity> CODEC = PlaceboCodecs.mapBackedDefaulted((String)"Wave Entity", CODECS, StandardWaveEntity.CODEC);

    public static void initSerializers() {
        WaveEntity.register("default", StandardWaveEntity.CODEC);
    }

    private static void register(String id, Codec<? extends WaveEntity> codec) {
        CODECS.put((Object)Gateways.loc(id), codec);
    }

    public LivingEntity createEntity(Level var1);

    public Component getDescription();

    public AABB getAABB(double var1, double var3, double var5);

    public boolean shouldFinalizeSpawn();

    public static class StandardWaveEntity
    implements WaveEntity {
        public static Codec<StandardWaveEntity> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)ForgeRegistries.ENTITY_TYPES.getCodec().fieldOf("entity").forGetter(t -> t.type), (App)NBTAdapter.EITHER_CODEC.optionalFieldOf("nbt").forGetter(t -> Optional.ofNullable(t.tag))).apply((Applicative)inst, StandardWaveEntity::new));
        protected final EntityType<?> type;
        protected final CompoundTag tag;

        public StandardWaveEntity(EntityType<?> type, Optional<CompoundTag> tag) {
            this.type = type;
            this.tag = tag.orElse(new CompoundTag());
            this.tag.m_128359_("id", EntityType.m_20613_(type).toString());
        }

        @Override
        public LivingEntity createEntity(Level level) {
            LivingEntity l;
            Entity ent = EntityType.m_20645_((CompoundTag)this.tag, (Level)level, Function.identity());
            return ent instanceof LivingEntity ? (l = (LivingEntity)ent) : null;
        }

        @Override
        public Component getDescription() {
            return Component.m_237115_((String)this.type.m_20675_());
        }

        @Override
        public AABB getAABB(double x, double y, double z) {
            return this.type.m_20585_(x, y, z);
        }

        @Override
        public boolean shouldFinalizeSpawn() {
            return this.tag.m_128440_() == 1 || this.tag.m_128471_("ForceFinalizeSpawn");
        }

        public Codec<? extends WaveEntity> getCodec() {
            return CODEC;
        }
    }
}

